﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;


public class Spaceship : MonoBehaviour
{
    public static Spaceship Instance;

    public Shield[] m_Shields;

    public GameObject m_LastShieldUI;
    public Collider m_LastShieldCollider;

    private void Awake()
    {
        Instance = this;
        for (int i = 0; i < m_Shields.Length; i++)
        {
            Shield shield = m_Shields[i];
            shield.gameObject.SetActive(false);
        }
    }

    public void OnTriggerEnter(Collider other)
    {
        Asteroid asteroid = other.gameObject.GetComponentInParent<Asteroid>();
        if (asteroid != null)
        {
            Game.Instance.AddEnergy(-asteroid.m_Level);
            SpawnHitEffect(asteroid);
            asteroid.Destroy();           
        }
    }

    public void RefreshShields()
    {
        int shieldLevel = Mathf.Min(m_Shields.Length, Game.Instance.m_LevelId);
        for (int i = 0; i < m_Shields.Length; i++)
        {
            Shield shield = m_Shields[i];
            bool isActive = (i <= shieldLevel - 1);

            if (Game.Instance.m_Panic && !shield.m_IsOnline)
            {
                shield.PutOffline(false);
            }
            else
            {
                if (isActive && !shield.m_IsOnline)
                {
                    shield.PutOnline();
                }
                else if (!isActive && shield.m_IsOnline)
                {
                    shield.PutOffline();
                    if (shield == Game.Instance.m_SelectedShield && i > 0)
                    {
                        shield.Deselect();
                        Game.Instance.m_SelectedShield = m_Shields[i - 1];
                        Game.Instance.m_SelectedShield.Select();
                    }
                }
            }

        }

        m_LastShieldUI.gameObject.SetActive(Game.Instance.m_LevelId > 0);
        m_LastShieldCollider.enabled = (Game.Instance.m_LevelId > 0);
    }

    private void SpawnHitEffect(Asteroid asteroid)
    {

        AsteroidHitEffect hitEffect = Instantiate(Game.Instance.m_AsteroidHitEffectPrefab) as AsteroidHitEffect;
        hitEffect.transform.SetParent(Game.Instance.m_AsteroidSpawner.m_HitEffectsRoot, true);
        hitEffect.transform.position = asteroid.transform.position;
        AudioClip hitAudioClip = Sounds.Instance.GetLastShielHitAudioClip();
        hitEffect.Initialize(hitAudioClip, asteroid);

    }

    public void ResetShields()
    {
        for (int i = 0; i < m_Shields.Length; i++)
        {
            m_Shields[i].Reset();
        }
    }
}
