﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Sounds : MonoBehaviour
{
    public static Sounds Instance;

    public AudioClip[] m_ShieldHits;
    public AudioClip[] m_LastShieldHits;
    public AudioClip[] m_BurstEvent;
    public AudioClip m_FinalExplosion;

    public AudioClip[] m_ShieldLevelUp;
    public AudioClip[] m_ShieldLevelDown;
    public AudioClip[] m_UIButtonSelect;
    public AudioClip m_GameStart;
    public AudioClip m_Panic;

    private AudioSource m_AudioSource;

    private void Awake()
    {
        Instance = this;
        m_AudioSource = GetComponent<AudioSource>();
    }

    public AudioClip GetShieldHitAudioClip()
    {
        return GetRandomAudioClip(m_ShieldHits);
    }
    public AudioClip GetLastShielHitAudioClip()
    {
        return GetRandomAudioClip(m_LastShieldHits);
    }
    public AudioClip GetBurstEventAudioClip()
    {
        return GetRandomAudioClip(m_BurstEvent);
    }

    public AudioClip GetShieldLevelUpAudioClip()
    {
        return GetRandomAudioClip(m_ShieldLevelUp);
    }
    public AudioClip GetShieldLevelDownAudioClip()
    {
        return GetRandomAudioClip(m_ShieldLevelDown);
    }
    public void PlayUIButtonSelectAudioClip(float volume=0.5f)
    {
        m_AudioSource.volume = volume;
        m_AudioSource.clip = GetRandomAudioClip(m_UIButtonSelect);
        m_AudioSource.Play();
    }

    private AudioClip GetRandomAudioClip(AudioClip[] audioClips)
    {
        int id = (int)(Random.value * audioClips.Length);
        return audioClips[id];
    }
}
