﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Scrap : MonoBehaviour
{
    public Image m_Image;
    float m_RotSpeed;
    public float m_MaxRotSpeed = 180;
    public float m_MinRotSpeed = 20;

    public Vector2 m_StartPos;
    private float m_Speed;

    public void Initialize()
    {
        m_Speed = (Random.value * 0.7f) + 0.3f;
        m_StartPos = transform.position;
        m_RotSpeed = Random.value * m_MaxRotSpeed - m_MaxRotSpeed / 2.0f;
        float sign = Mathf.Sign(m_RotSpeed);
        if (Mathf.Abs(m_RotSpeed) < m_MinRotSpeed)
        {
            m_RotSpeed = m_RotSpeed + sign * m_MinRotSpeed;
        }
    }
    public void Reset()
    {
        StopAllCoroutines();
        transform.position = m_StartPos;
        m_Image.color = Color.white;
    }
    // Update is called once per frame
    void Update()
    {
        transform.Rotate(new Vector3(0, 0, m_RotSpeed * Time.deltaTime));
    }

    public void GetOut()
    {
        StopAllCoroutines();
        if (gameObject.activeInHierarchy)
        {
            StartCoroutine(GetOutCoroutine());
        }
        
    }
    private IEnumerator GetOutCoroutine()
    {
        while (true)
        {
            Vector3 dir = transform.position.normalized;
            Vector3 move = dir * Time.deltaTime*7 * m_Speed;
            transform.Translate(move, Space.World);
            yield return null;
        }
    }
}
