﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class ReStartLevelButton : MonoBehaviour, ISelectHandler
{
    RectTransform m_RectTransform;
    Button m_Button;

    void Awake()
    {
        m_RectTransform = GetComponent<RectTransform>();
        m_Button = GetComponent<Button>();
    }
    public void OnSelect(BaseEventData eventData)
    {
        RectTransform levelSelector = ReStartLevelSelector.Instance.GetComponent<RectTransform>();
        levelSelector.anchoredPosition = new Vector2(m_RectTransform.anchoredPosition.x, levelSelector.anchoredPosition.y);


            Sounds.Instance.PlayUIButtonSelectAudioClip();

    }
    public void OnPointerEnter(PointerEventData eventData)
    {
        m_Button.Select();
    }
}
