﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class LastShield : MonoBehaviour
{
    private Image m_Image;
    private float m_TargetAlpha=1;
    public float m_RegenRate = 0.5f;

    private float m_TargetScale = 1;
    public float m_ScaleRegenRate = .5f;


    private void Awake()
    {
        m_Image = GetComponent<Image>();
        Reset();
    }

    public void Reset()
    {
        transform.localScale = Vector3.one * 0.2f;
        m_Image.color = new Color(1, 1, 1, 0);
        m_TargetAlpha = 1;
        m_TargetScale = 1;
    }

    private void Update()
    {
        if (!Game.Instance.GameRunning)
        {
            return;
        }
        if (m_TargetAlpha != m_Image.color.a)
        {
            Color c = m_Image.color;
            c.a = Mathf.Lerp(c.a, m_TargetAlpha, Time.deltaTime * 10);
            m_Image.color = c;
        }
        if (m_TargetAlpha < 1)
        {
            m_TargetAlpha = Mathf.Clamp01(m_TargetAlpha + Time.deltaTime * m_RegenRate);
        }

        if(m_TargetScale != transform.localScale.x)
        {
            float s = Mathf.Lerp(transform.localScale.x, m_TargetScale, Time.deltaTime * 20);
            transform.localScale = Vector3.one * s;
        }
        if(m_TargetScale < 1)
        {
            m_TargetScale = Mathf.Clamp01(m_TargetScale + Time.deltaTime * m_ScaleRegenRate);
        }
    }
    public void Hit(float intensity)
    {
        float shieldLeak = intensity;
        m_TargetAlpha = Mathf.Clamp(m_TargetAlpha - shieldLeak, 0.2f, 1);

        
        m_TargetScale = Mathf.Clamp(m_TargetScale - shieldLeak/20f, 0.8f, 1);
    }


}
