﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Hull : MonoBehaviour
{
    public void OnTriggerEnter(Collider other)
    {
        Asteroid asteroid = other.gameObject.GetComponentInParent<Asteroid>();
        if (asteroid != null)
        {
            Game.Instance.AddEnergy(-asteroid.m_Level);

            SpawnHitEffect(asteroid);
            asteroid.Destroy();
        }
    }

    private void SpawnHitEffect(Asteroid asteroid)
    {

        AsteroidHitEffect hitEffect = Instantiate(Game.Instance.m_AsteroidHitEffectPrefab) as AsteroidHitEffect;
        hitEffect.transform.SetParent(Game.Instance.m_AsteroidSpawner.m_HitEffectsRoot);
        hitEffect.transform.position = asteroid.transform.position;
        AudioClip hitAudioClip = Sounds.Instance.GetLastShielHitAudioClip();
        hitEffect.Initialize(hitAudioClip, asteroid);

    }
}
