﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BackgroundMover : MonoBehaviour
{
    private RectTransform m_RectTransform;

    public Vector2 m_Repeat = new Vector2(3840,0);
    public Vector2 m_Speed = new Vector3(-1,0);

    private Vector2 m_Parcouru = new Vector2(0, 0);
    // Start is called before the first frame update
    void Start()
    {
        m_RectTransform = GetComponent<RectTransform> ();
    }

    // Update is called once per frame
    void Update()
    {
        float speedMultiplicator = Game.Instance.m_IsSpeedFast ? 0.75f : 0.2f;
        if (Game.Instance.GameRunning)
        {
            speedMultiplicator *= (0.5f+Game.Instance.m_LevelId*0.25f);
        }
        Vector2 move = m_Speed * speedMultiplicator * Time.deltaTime;
        m_Parcouru += move;

        if (m_Parcouru.x < -m_Repeat.x)
        {
            move.x += m_Repeat.x;
            m_Parcouru.x += m_Repeat.x;
        }

            
    

        m_RectTransform.anchoredPosition = m_RectTransform.anchoredPosition + move;

    }
}
