﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AsteroidSpawner : MonoBehaviour
{
    public static AsteroidSpawner Instance;

    public Asteroid[] m_AsteroidPrefabs;
    public AsteroidIndicator m_AsteroidIndicatorPrefab;
    public Transform m_HitEffectsRoot;
    public Transform m_AsteroidsRoot;
    public Transform m_IndicatorsRoot;

    public List<Asteroid> m_Asteroids;
    private int m_AsteroidCount=1;
    private AudioSource m_AudioSource;

    private void Awake()
    {
        Instance = this;
        m_AudioSource = GetComponent<AudioSource>();
        // Remove temp Asteroids and indicators
        KillAll();
    }

    private void Start()
    {
        m_Asteroids = new List<Asteroid>();
    }

    public void StartSpawn()
    {
        KillAll();
        StopAllCoroutines();
        StartCoroutine(SpawnCoroutine());
        StartCoroutine(BurstCoroutine());
    }
    public void StopSpawn()
    {
        StopAllCoroutines();
    }
    public void KillAll()
    {
        foreach (Transform t in m_AsteroidsRoot)
        {
            Destroy(t.gameObject);
        }
        foreach (Transform t in m_IndicatorsRoot)
        {
            Destroy(t.gameObject);
        }
        m_Asteroids = new List<Asteroid>();

        foreach (Transform t in m_HitEffectsRoot)
        {
            Destroy(t.gameObject);
        }
    }

    

    IEnumerator SpawnCoroutine()
    {
        while (true)
        {
            Spawn();

            float minPopTime = Game.Instance.m_MaxLevelReached.m_MinAsteroidPopTime;
            float maxPopTime = Game.Instance.m_MaxLevelReached.m_MaxAsteroidPopTime;
            float difficultyMultiplicator = Game.Instance.DifficultyMultiplicatorOverTime;
            float nextPopTime = (minPopTime + Random.value * (maxPopTime - minPopTime)) / difficultyMultiplicator;
            yield return new WaitForSeconds(nextPopTime);
        }
    }
    IEnumerator BurstCoroutine()
    {
        while (true)
        {
            float nextBurstTime = (15 + (0.5f+Random.value*0.5f) * 30) / Game.Instance.m_BurstMultiplier;
            yield return new WaitForSeconds(nextBurstTime);

            m_AudioSource.clip = Sounds.Instance.GetBurstEventAudioClip();
            m_AudioSource.Play();
            int numBurst = (int)(Game.Instance.DifficultyMultiplicatorOverTime * (0.5f+ Random.value*0.5f) *10 * Game.Instance.m_BurstMultiplier);
            numBurst = Mathf.Clamp(numBurst, 5, 25);

            for (int i = 0; i < numBurst; i++)
            {
                Spawn(1);
                yield return new WaitForSeconds(0.2f+ Random.value * 0.3f);
            }

            
        }
    }



    public void Spawn(int level=-1)
    {
        int prefabId = (int)(Random.value * m_AsteroidPrefabs.Length);

        Asteroid newAsteroid = Instantiate(m_AsteroidPrefabs[prefabId]).GetComponent<Asteroid>();
        newAsteroid.Initialize(level);
        newAsteroid.name = "Asteroid_" + m_AsteroidCount.ToString("0000");
        m_AsteroidCount++;
        newAsteroid.transform.SetParent(m_AsteroidsRoot, true);
        m_Asteroids.Add(newAsteroid);



    }
}
