﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AsteroidHitEffect : MonoBehaviour
{
    public AudioSource m_AudioSource;
    public ParticleSystem m_ParticleSystem;
    public ParticleSystem m_ParticleSystem_Energy;


    public void Initialize(AudioClip audioClip, Asteroid asteroid)
    {
        transform.rotation = Quaternion.Euler(0, 0, asteroid.m_Angle);
        transform.Translate(new Vector3(0, 0, -0.1f), Space.World);
        float levelPart = (asteroid.m_Level * 0.5f);
        float speedPart = asteroid.m_Speed / 3.0f;
        float pitch = 1 - levelPart + speedPart;
        m_AudioSource.pitch = Mathf.Clamp(pitch, 0.5f, 2);
        m_AudioSource.clip = audioClip;
        m_AudioSource.Play();
        var main = m_ParticleSystem_Energy.main;
        main.startSize = asteroid.m_Level;

        m_ParticleSystem.Play();
    }

    private void Update()
    {
        if (!m_AudioSource.isPlaying && !m_ParticleSystem.IsAlive())
        {
            Destroy(gameObject);
        }
    }
}
