using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System;
using System.Linq;
using System.Text.RegularExpressions;
using UnityEditor.Build.Reporting;

public class BuildManager {

    enum TargetArchitecture
    {
        Default, _32, _64, ForStore
    }

#if(UNITY_ANDROID)
    [MenuItem("Build/32bits/Build", false, 200)]
    static void BuildAndroid32()
    {
        Debug.Log("Build Android 32bits");
        PerformBuild(BuildOptions.None, TargetArchitecture._32);
    }
    [MenuItem("Build/32bits/Build and run", false, 200)]
    static void BuildAndRunAndroid32()
    {
        Debug.Log("Build and run Android 32bits");
        PerformBuild(BuildOptions.AutoRunPlayer, TargetArchitecture._32);
    }

    [MenuItem("Build/64bits/Build", false, 200)]
    static void BuildAndroid64()
    {
        Debug.Log("Build Android 64bits");
        PerformBuild(BuildOptions.None, TargetArchitecture._64);
    }
    [MenuItem("Build/64bits/Build and run", false, 200)]
    static void BuildAndRun64()
    {
        Debug.Log("Build and run 64bits");
        PerformBuild(BuildOptions.AutoRunPlayer, TargetArchitecture._64);
    }

    [MenuItem("Build/Build for store (32 and 64 bits)", false, 200)]
    static void BuildAndroidStore()
    {
        Debug.Log("Build for store (32 et 64 bits)");
        PerformBuild(BuildOptions.None, TargetArchitecture.ForStore);
    }
#else
    [MenuItem("Build/Build", false, 200)]
    static void Build()
    {
        Debug.Log("Build");
        PerformBuild(BuildOptions.None, TargetArchitecture.Default);
    }

    [MenuItem("Build/Build and run", false, 200)]
    static void BuildAndRun()
    {
        Debug.Log("Build and run");
        PerformBuild(BuildOptions.AutoRunPlayer, TargetArchitecture.Default);
    }
#endif

    static void PerformBuild(BuildOptions buildOptions, TargetArchitecture targetArchitecture)
    {
        if (CheckSupportedPlatform())
        {

#if (UNITY_ANDROID)
            TargetArchitecture saveTargetArchitecture = targetArchitecture;

            if (targetArchitecture == TargetArchitecture.ForStore)
            {
                EditorUserBuildSettings.buildAppBundle = true;

                saveTargetArchitecture = TargetArchitecture.ForStore;
                targetArchitecture = TargetArchitecture._32;
            }
            else
                EditorUserBuildSettings.buildAppBundle = false;


            SetTargetArchitectureForAndroid(targetArchitecture);
            SetAndroidBundleVersion(targetArchitecture);
#endif

            BuildReport report = BuildPipeline.BuildPlayer(GetBuildScenes(), GetPath(), EditorUserBuildSettings.activeBuildTarget, buildOptions);
            BuildSummary summary = report.summary;

#if (UNITY_ANDROID)
            if (saveTargetArchitecture == TargetArchitecture.ForStore && summary.result == BuildResult.Succeeded)
            {
                targetArchitecture = TargetArchitecture._64;

                SetTargetArchitectureForAndroid(targetArchitecture);
                SetAndroidBundleVersion(targetArchitecture);

                report = BuildPipeline.BuildPlayer(GetBuildScenes(), GetPath(), EditorUserBuildSettings.activeBuildTarget, buildOptions);
            }
#endif

        }
        else
        {
            Debug.LogError("Unsupported Platform");
        }
    }

    private static bool CheckSupportedPlatform()
    {
        bool isSupported = true;
        switch (EditorUserBuildSettings.activeBuildTarget)
        {
            case BuildTarget.StandaloneWindows:
                break;
            case BuildTarget.StandaloneWindows64:
                break;
            case BuildTarget.Android:
                break;
            case BuildTarget.WebGL:
                break;
            default:
                isSupported = false;
                break;
        }
        return isSupported;
    }

    static bool isAndroidPlateform()
    {
        return EditorUserBuildSettings.activeBuildTarget == BuildTarget.Android;
    }

    static void SetTargetArchitectureForAndroid(TargetArchitecture targetArchitecture)
    {
        if (targetArchitecture == TargetArchitecture._32)
        {
            PlayerSettings.SetScriptingBackend(BuildTargetGroup.Android, ScriptingImplementation.Mono2x);
            PlayerSettings.Android.targetArchitectures = AndroidArchitecture.ARMv7 | AndroidArchitecture.ARM64;
        }
        else if (targetArchitecture == TargetArchitecture._64)
        {
            PlayerSettings.SetScriptingBackend(BuildTargetGroup.Android, ScriptingImplementation.IL2CPP);
            PlayerSettings.Android.targetArchitectures = AndroidArchitecture.ARM64;
        }
    }
    static void SetAndroidBundleVersion(TargetArchitecture targetArchitecture)
    {
        string targetArchitect = "";
        int newBundleVersionCode;

        if (targetArchitecture == TargetArchitecture._32)
            targetArchitect = "32";
        else if (targetArchitecture == TargetArchitecture._64)
            targetArchitect = "64";

        targetArchitect += PlayerSettings.bundleVersion.Replace(".", "");
        int.TryParse(targetArchitect, out newBundleVersionCode);

        PlayerSettings.Android.bundleVersionCode = newBundleVersionCode;
    }

    static EditorBuildSettingsScene[] GetBuildScenes()
    {
       return EditorBuildSettings.scenes;
    }

    static string GetPath()
    {
        //string url = "Build/Android/" + (PlayerSettings.bundleIdentifier.Replace("fr.numix.", "") + ".v" + PlayerSettings.bundleVersion).Replace(".", "_") + ".apk";
        //Debug.Log(url);
        //return url;

        string path = "Build/" + GetPlatformName() + "/";

        switch (EditorUserBuildSettings.activeBuildTarget)
        {
            case BuildTarget.StandaloneWindows:
                path += GetBuildName() + "/" + GetBuildName() + ".exe";
                break;
            case BuildTarget.StandaloneWindows64:
                path += GetBuildName() + "/" + GetBuildName() + ".exe";
                break;
            case BuildTarget.Android:
                path += GetBuildName() + GetTargetArchitectureName() + ".apk";
                break;
            case BuildTarget.WebGL:
                path += GetBuildName();
                break;
            default:
                break;
        }


        Debug.Log(path);

        return path;
    }
    

    static string GetBuildName()
    {
        return PlayerSettings.productName + "_V" + PlayerSettings.bundleVersion.Replace(".", "_");
    }

    static string GetTargetArchitectureName()
    {
        string architectName = "";

        string architecturesSelected = PlayerSettings.Android.targetArchitectures.ToString();
        if(architecturesSelected.Contains(AndroidArchitecture.ARMv7.ToString()) || architecturesSelected.Contains(AndroidArchitecture.ARM64.ToString()))
        {
            architectName = "_32bits";
        }
        else if (architecturesSelected.Contains(AndroidArchitecture.ARM64.ToString()))
        {
            architectName = "_64bits";
        }

        return architectName;
    }

    static string GetPlatformName()
    {
        BuildTarget buildTarget = EditorUserBuildSettings.activeBuildTarget;
        switch (buildTarget)
        {
            case BuildTarget.StandaloneWindows:
                return "WindowsX86";
            case BuildTarget.StandaloneWindows64:
                return "Windows";
            default:
                return buildTarget.ToString();
        }
    }


}
